---
title: API token templates · Cloudflare Fundamentals docs
description: Explore Cloudflare's API token templates to efficiently manage
  permissions. Start with a template and customize token permissions and
  resources as needed.
lastUpdated: 2025-05-05T16:36:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/api/reference/template/
  md: https://developers.cloudflare.com/fundamentals/api/reference/template/index.md
---

Below is a table of the currently available API token templates and the default [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) they grant. You can start creating a token with one of these templates and modify the permissions and resources from there.

| Template Name | Permission | Resource |
| - | - | - |
| Edit Zone DNS | DNS Write | Zone |
| Read billing info | Billing Read | Account |
| Account resources: Include all accounts | | |
| Read analytics and logs | Analytics Read | Zone |
| Logs Read | Zone | |
| Edit Cloudflare Workers | Workers Routes Write | Zone |
| Workers Scripts Write | Account | |
| Workers KV Storage Write | Account | |
| Workers Tail Read | Account | |
| Workers R2 Storage Write | Account | |
| Account Settings Read | Account | |
| User Details Read | User | |
| User Memberships Read | User | |
| Edit load balancing configuration | Load Balancing: Monitors and Pools Write | Account |
| Load Balancers Write | Zone | |
| WordPress | Analytics Read | Zone |
| Zone Read | Zone | |
| Zone Settings Write | Zone | |
| Account Settings Read | Account | |
| DNS Read | Zone | |
| Cache Purge | Zone | |
| Account resources: Include all accounts | | |
| Zone resources: Include all zones | | |
| Create Additional Tokens | API Tokens Write | User |
| Read All Resources | *(All read permissions)* | Account, Zone, User |
| Account resources: Include all accounts | | |
| Zone resources: Include all zones | | |
