---
title: Mutual TLS (mTLS) · Cloudflare Learning Paths
description: Mutual TLS (mTLS) authentication uses client certificates to ensure
  traffic between client and server is bidirectionally secure and trusted. mTLS
  also allows requests that do not authenticate via an identity provider — such
  as Internet-of-things (IoT) devices — to demonstrate they can reach a given
  resource.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/application-security/default-traffic-security/mtls/
  md: https://developers.cloudflare.com/learning-paths/application-security/default-traffic-security/mtls/index.md
---

Mutual TLS (mTLS) authentication uses client certificates to ensure traffic between client and server is bidirectionally secure and trusted. mTLS also allows requests that do not authenticate via an identity provider — such as Internet-of-things (IoT) devices — to demonstrate they can reach a given resource.

![mTLS sequence diagram](https://developers.cloudflare.com/_astro/api-shield-call-sequence.DjXyNgan_ZJ06pk.webp)

Support includes [gRPC](https://grpc.io/docs/what-is-grpc/introduction/)-based APIs, which use binary formats such as protocol buffers rather than JSON.

## Creating a mTLS rule

1. In the Cloudflare dashboard, go to **Client Certificates** page.

   [Go to **Client Certificates**](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/client-certificates)

2. Select **Create a mTLS rule**.

3. In **Custom rules**, several rule parameters have already been filled in. Enter the URI path you want to protect in **Value**.

4. (Optional) Add a `Hostname` field and enter the mTLS-enabled hostnames you wish to protect in **Value**.

5. In **Choose action**, select `Block`.

6. Select **Deploy** to make the rule active.

Once you have deployed your mTLS rule, any requests without a [valid client certificate](https://developers.cloudflare.com/ssl/client-certificates/) will be blocked.
