---
title: Static threshold rule · Cloudflare Magic Network Monitoring docs
description: A static threshold rule allows you to define a constant numeric
  threshold, in terms of bits or packets, for DDoS traffic monitoring. The total
  traffic across all IP prefixes and IP addresses in the rule is compared to the
  static rule threshold. If the total traffic exceeds the static rule threshold
  for the duration of the rule, then an alert is sent.
lastUpdated: 2025-11-19T16:38:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-network-monitoring/rules/static-threshold/
  md: https://developers.cloudflare.com/magic-network-monitoring/rules/static-threshold/index.md
---

A static threshold rule allows you to define a constant numeric threshold, in terms of bits or packets, for DDoS traffic monitoring. The total traffic across all IP prefixes and IP addresses in the rule is compared to the static rule threshold. If the total traffic exceeds the static rule threshold for the duration of the rule, then an alert is sent.

Customers that send NetFlow and/or sFlow data to Cloudflare can configure static threshold rules.

## Rule configuration fields

| Field | Description |
| - | - |
| **Rule name** | Must be unique and cannot contain spaces. Supports characters `A-Z`, `a-z`, `0-9`, underscore (`_`), dash (`-`), period (`.`), and tilde (`~`). Maximum of 256 characters. |
| **Rule type** | threshold |
| **Rule threshold type** | Can be defined in either bits per second or packets per second. |
| **Rule threshold** | The number of bits per second or packets per second for the rule alert. When this value is exceeded for the rule duration, an alert notification is sent. Minimum of `1` and no maximum. |
| **Rule duration** | The amount of time in minutes the rule threshold must exceed to send an alert notification. Choose from the following values: `1`, `5`, `10`, `15`, `20`, `30`, `45`, or `60` minutes. |
| **Auto-advertisement** | If you are a Magic Transit On Demand customer, you can enable this feature to automatically enable Magic Transit if the rule alert is triggered. Magic Network Monitoring supports Magic Transit's supernet capability. To learn more refer to [Auto-Advertisement section](#rule-auto-advertisement). |
| **Rule IP prefix** | The IP prefix associated with the rule for monitoring traffic volume. Must be a CIDR range such as `160.168.0.1/24`. Max is 5,000 unique CIDR entries. To learn more and see an example, view the [Rule IP prefixes](#rule-ip-prefixes) section. |

## API documentation

To review an example static threshold rule, go to the [Rules](https://api.cloudflare.com/#magic-network-monitoring-rules-properties) section in the Magic Network Monitoring API documentation.

## Recommended rule configuration

You can create [Magic Network Monitoring rules](https://dash.cloudflare.com/?to=/:account/network-monitoring) to monitor the traffic volume of your network for a set of IP prefixes and / or IP addresses. The traffic volume threshold for these rules is also set by you. If the traffic volume threshold is crossed, Magic Network Monitoring will send an alert via email, webhook, or PagerDuty.

Follow the guidelines outlined in this page to create appropriate Magic Network Monitoring rules and set accurate rule thresholds.

### Rule IP prefixes

Cloudflare recommends that customers start by creating one Magic Network Monitoring rule for each public `/24` IP prefix within their network. It is helpful to include the range of the `/24` IP prefix to make it easier to find and filter for the rule in Magic Network Monitoring analytics.

As you become more familiar with the traffic patterns across each IP prefix, we encourage you to create more complex rules with IP prefixes that are smaller or larger than a `/24` prefix depending on your needs. You can also combine and monitor multiple IP prefixes within the same rule.

### Rule threshold

Follow the steps below to configure appropriate rule thresholds.

#### Initial rule configuration

When you initially configure Magic Network Monitoring, you may not know the typical traffic volume patterns across each of your IP prefixes. Cloudflare recommends that you set a high rule threshold of either 10 Gbps (gigabits per second) or 10 Mpps (million packets per second) that is unlikely to be crossed during initial configuration.

This will allow you to collect initial information about the typical traffic volume for a Magic Network Monitoring rule without receiving any alerts. After configuring your initial rules, you should begin monitoring for alerts and reviewing network traffic in Magic Network Monitoring Analytics. Over time, each rule's threshold should be updated based on historical traffic data.

| Threshold type | Recommended rule threshold to collect initial data |
| - | - |
| Bits | 10 Gpbs (10,000,000,000 bits per second) |
| Packets | 10 Mpps (10,000,000 packets per second) |

#### Setting the appropriate threshold

After creating the initial set of rules to monitor your network traffic, you should collect 14-30 days of historical traffic volume data for each rule.

Cloudflare recommends that new customers set a rule threshold that is two times larger than the maximum non-attack traffic observed for a one minute time interval within an rule.

To find the maximum non-attack traffic for a one minute time interval over the past 14-30 days, you can filter for the specific rule you want to analyze. To do that:

1. In the Cloudflare dashboard, go to the **Magic Monitoring** page.

[Go to **Magic monitoring**](https://dash.cloudflare.com/?to=/:account/network-monitoring)

1. Select **Add filter**.
2. In **New filter**, use the drop-down menus to create the following filter:

| Field | Operator | Rule name |
| - | - | - |
| *Monitoring Rule* | *equals* | `<RULE_NAME>` |

Once the rule filter is selected in Analytics, you can check the historical traffic volume data for the rule over the selected time period. We recommend that you check your historical traffic volume data in increments of seven days since that is the largest window that shows one hour time intervals. You can select a custom seven-day time range in Analytics by going to the top right corner of analytics, opening the time window dropdown, and selecting **Custom range**.

You should review the selected seven-day time range and identify the largest traffic volume peak. Then, click and drag on the largest traffic peak to view the traffic volume data for a smaller time window. Continue until you are viewing the traffic volume data in one-minute intervals.

Record the largest traffic volume peak for the rule in a spreadsheet, then repeat this process across 14-30 days of data. The rule threshold should be updated to be two times the largest traffic spike for a one minute time interval across 14-30 days of data. You should go through this process to set the threshold for each rule.

### Rule duration

Your IP prefixes may experience inconsistent spikes in traffic volume across one minute time intervals. We recommend that you set a rule duration of 120 seconds or greater to reduce false positive alerts on short-term non-malicious traffic spikes. A rule duration of 120 seconds means that the traffic volume must be above the rule threshold for 120 seconds before an alert is fired.

### Adjusting rules over time

After you update your first set of rule thresholds based on historical traffic data, it will be important to monitor for alerts to check if the rule thresholds are appropriate. Customers are encouraged to adjust the rule thresholds and the duration over time to find the ideal alert sensitivity level for their specific network environment.
