---
title: Design Guides · Cloudflare Reference Architecture docs
description: Design guides take your knowledge from a reference architecture and
  walk through the conceptual decisions and directions you should take to
  implement a specific solution. They do not replace our product documentation,
  but instead provide guidance on the decisions you should make given a certain
  solution you are trying to deploy.
lastUpdated: 2024-12-12T12:06:35.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/reference-architecture/design-guides/
  md: https://developers.cloudflare.com/reference-architecture/design-guides/index.md
---

Diagrams, design patterns and detailed best practices to help you generate solutions with Cloudflare products.

Design guides take your knowledge from a reference architecture and walk through the conceptual decisions and directions you should take to implement a specific solution. They do not replace our product documentation, but instead provide guidance on the decisions you should make given a certain solution you are trying to deploy.



* [Extend Cloudflare's benefits to SaaS providers' end-customers](https://developers.cloudflare.com/reference-architecture/design-guides/extending-cloudflares-benefits-to-saas-providers-end-customers/)
* [Designing ZTNA access policies for Cloudflare Access](https://developers.cloudflare.com/reference-architecture/design-guides/designing-ztna-access-policies/)
* [Leveraging Cloudflare for your SaaS applications](https://developers.cloudflare.com/reference-architecture/design-guides/leveraging-cloudflare-for-your-saas-applications/)
* [Network-focused migration from VPN concentrators to Zero Trust Network Access](https://developers.cloudflare.com/reference-architecture/design-guides/network-vpn-migration/)
* [Securely deliver applications with Cloudflare](https://developers.cloudflare.com/reference-architecture/design-guides/secure-application-delivery/)
* [Streamlined WAF deployment across zones and applications](https://developers.cloudflare.com/reference-architecture/design-guides/streamlined-waf-deployment-across-zones-and-applications/)
* [Using a zero trust framework to secure SaaS applications](https://developers.cloudflare.com/reference-architecture/design-guides/zero-trust-for-saas/)
* [Building zero trust architecture into your startup](https://developers.cloudflare.com/reference-architecture/design-guides/zero-trust-for-startups/)
* [Securing guest wireless networks](https://developers.cloudflare.com/reference-architecture/design-guides/securing-guest-wireless-networks/)
