---
title: Rewrite path for object storage bucket · Cloudflare Rules docs
description: Create a URL rewrite rule (part of Transform Rules) to rewrite any
  requests for `/files/...` URI paths to `/...`.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: URL rewrite
source_url:
  html: https://developers.cloudflare.com/rules/transform/examples/rewrite-path-object-storage/
  md: https://developers.cloudflare.com/rules/transform/examples/rewrite-path-object-storage/index.md
---

To remove `/files/` from URI paths before routing request to your object storage bucket, create a new URL rewrite rule and define a dynamic URL path rewrite using [wildcard pattern parameters](https://developers.cloudflare.com/rules/transform/url-rewrite/create-dashboard/#wildcard-pattern-parameters):

**When incoming requests match**

* **Wildcard pattern**
  * **Request URL**: `https://<YOUR_HOSTNAME>/files/*`

**Then rewrite the path and/or query**

* **Target path**: \[`/`] `files/*`
* **Rewrite to**: \[`/`] `${1}`

Make sure to replace `<YOUR_HOSTNAME>` with your actual hostname and adjust the example paths according to your setup. Then, use [Cloud Connector](https://developers.cloudflare.com/rules/cloud-connector/) to route traffic to an object storage bucket.
