---
title: Set a response header with the current bot score · Cloudflare Rules docs
description: Create a response header transform rule (part of Transform Rules)
  to set an `X-Bot-Score` HTTP header in the response with the current bot
  score.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Response modification
source_url:
  html: https://developers.cloudflare.com/rules/transform/examples/set-response-header-bot-score/
  md: https://developers.cloudflare.com/rules/transform/examples/set-response-header-bot-score/index.md
---

The following response header transform rule sets a header named `X-Bot-Score` to the current bot score in the HTTP response:

Text in **Expression Editor**:

```txt
starts_with(http.request.uri.path, "/en/")
```

Selected operation under **Modify response header**: *Set dynamic*

**Header name**: `X-Bot-Score`

**Value**: `to_string(cf.bot_management.score)`

This rule would overwrite any existing `X-Bot-Score` headers already present in the HTTP response.
